/***************************************************************
 *                    simula.plus@cemes.fr                     *
 *                   GNU/linux version 3.2.0                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright © 2008,2012 COLLARD Christophe
 * copyright © 2008,2012 Centre National de la Recherche Scientifique
 * copyright © 2008 Arts et Métiers ParisTech
 * copyright © 2008 Laboratoire de Physique et Mécanique des Matériaux (LPMM - CNRS)
 * copyright © 2012 Centre d'Elaboration de Matériaux et d'Etudes Structurales (CEMES - CNRS)
 *****************************************************************/

/*
    Schmid_tensor-test belongs to Materials Object Libraries (MateriOL++)
    MateriOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for the type Schmid_tensor-test
#endif

#ifndef __Schmid_tensor_test_hpp
#define __Schmid_tensor_test_hpp


#ifndef __iostream
#include <iostream>
#endif

#ifndef __stdio_h
#include <stdio.h>
#endif

#ifndef __stdlib_h
#include <stdlib.h>
#endif

#ifndef __colors_hpp
#include "colors.hpp"
#endif

#ifndef __parameters_h
#include "parameters.h"
#endif

#ifndef __isotropic_tensors_hpp
#include "MateriOL++/isotropic tensors.hpp"
#endif

#ifndef __Schmid_tensor_hpp
#include "MateriOL++/Schmid tensor.hpp"
#endif

#ifndef __affiche_hpp
#include "tests/affiche.hpp"
#endif

using namespace materiol;


//=================================
int test_Schmid_tensor (int detail)
//=================================
{
  int result=1;

  if (detail < 0) 
    { cout << "============================================================== \n";
      cout << blue << "                  Schmid tensor test skipped" << reset;
      cout << "============================================================== \n";
      return result;
    }

  ifstream file("data/slip systems.dat", ios::in);
  assert (!file.fail());
  Schmid_tensor<long double> vr(file);
  Schmid_tensor<long double> vr1(file);
  file.close();

  vector<long double> n(3), m(3);
  n[1] = -1.820000E-01;
  n[2] = 6.690000E-01;
  n[3] = 7.210000E-01;
  m[1] = -1.650000E-01;
  m[2] = -7.370000E-01;
  m[3] = 6.550000E-01;
  Schmid_tensor<long double> vr2(n,m);

  vector<long double> n1(3), m1(3);
  n1[1] = -1.820000E-01;
  n1[2] = 7.210000E-01;
  n1[3] = 6.690000E-01;
  m1[1] = -1.650000E-01;
  m1[2] = 6.550000E-01;
  m1[3] = -7.370000E-01;

  n /= n.norm();
  m /= m.norm();
  n1 /= n1.norm();
  m1 /= m1.norm();

  int test = true;

  for (int i=1; i<=3; i++)
    for (int j=1; j<=3; j++)
      { test *= (abs(vr(i,j)-0.5*(n[i]*m[j]+n[j]*m[i]))<epsilon);
	test *= (abs(vr1(i,j)-0.5*(n1[i]*m1[j]+n1[j]*m1[i]))<epsilon);
	test *= (abs(vr(i,j)-vr2(i,j))<epsilon);
      }

  if (detail) affiche ("Schmid tensor:", test);
  else result *= (test);

  if (detail) affiche ("normal unit vector to slip plane", vr.n()==n && vr1.n()==n1);
  else result *= (vr.n()==n && vr1.n()==n1);

  if (detail) affiche ("normal unit vector in the slip direction", vr.m()==m && vr1.m()==m1);
  else result *= (vr.m()==m && vr1.m()==m1);

  cout << endl;

  cout << "============================================================== \n";
  if (result) cout << green << "                  Schmid tensor test passed" << reset;
  else cout << red << "                  Schmid tensor test failed" << reset;
  cout << "============================================================== \n";

  return result;
}


#endif
